/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class FixProjectileStoredItem
extends DataFix {
    private static final String EMPTY_POTION = "minecraft:empty";

    public FixProjectileStoredItem(Schema p_309054_) {
        super(p_309054_, true);
    }

    protected TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.ENTITY);
        Type $$1 = this.getOutputSchema().getType(References.ENTITY);
        return this.fixTypeEverywhereTyped("Fix AbstractArrow item type", $$0, $$1, ExtraDataFixUtils.chainAllFilters(this.fixChoice("minecraft:trident", FixProjectileStoredItem::castUnchecked), this.fixChoice("minecraft:arrow", FixProjectileStoredItem::fixArrow), this.fixChoice("minecraft:spectral_arrow", FixProjectileStoredItem::fixSpectralArrow)));
    }

    private Function<Typed<?>, Typed<?>> fixChoice(String p_309076_, SubFixer<?> p_309176_) {
        Type $$2 = this.getInputSchema().getChoiceType(References.ENTITY, p_309076_);
        Type $$3 = this.getOutputSchema().getChoiceType(References.ENTITY, p_309076_);
        return FixProjectileStoredItem.fixChoiceCap(p_309076_, p_309176_, $$2, $$3);
    }

    private static <T> Function<Typed<?>, Typed<?>> fixChoiceCap(String p_309198_, SubFixer<?> p_309081_, Type<?> p_309063_, Type<T> p_308929_) {
        OpticFinder $$4 = DSL.namedChoice((String)p_309198_, p_309063_);
        SubFixer<?> $$5 = p_309081_;
        return p_309195_ -> p_309195_.updateTyped($$4, p_308929_, p_309191_ -> $$5.fix((Typed<?>)p_309191_, p_308929_));
    }

    private static <T> Typed<T> fixArrow(Typed<?> p_308973_, Type<T> p_309096_) {
        return Util.writeAndReadTypedOrThrow(p_308973_, p_309096_, p_309043_ -> p_309043_.set("item", FixProjectileStoredItem.createItemStack(p_309043_, FixProjectileStoredItem.getArrowType(p_309043_))));
    }

    private static String getArrowType(Dynamic<?> p_308995_) {
        return p_308995_.get("Potion").asString(EMPTY_POTION).equals(EMPTY_POTION) ? "minecraft:arrow" : "minecraft:tipped_arrow";
    }

    private static <T> Typed<T> fixSpectralArrow(Typed<?> p_309000_, Type<T> p_308931_) {
        return Util.writeAndReadTypedOrThrow(p_309000_, p_308931_, p_309009_ -> p_309009_.set("item", FixProjectileStoredItem.createItemStack(p_309009_, "minecraft:spectral_arrow")));
    }

    private static Dynamic<?> createItemStack(Dynamic<?> p_308907_, String p_309016_) {
        return p_308907_.createMap((Map)ImmutableMap.of((Object)p_308907_.createString("id"), (Object)p_308907_.createString(p_309016_), (Object)p_308907_.createString("Count"), (Object)p_308907_.createInt(1)));
    }

    private static <T> Typed<T> castUnchecked(Typed<?> p_309048_, Type<T> p_309151_) {
        return new Typed(p_309151_, p_309048_.getOps(), p_309048_.getValue());
    }

    static interface SubFixer<F> {
        public Typed<F> fix(Typed<?> var1, Type<F> var2);
    }
}

